"""
FastAPI Backend for Krystal EA Digital Weighing Scale System
Main entry point - imports the refactored application structure.
"""

import os
import sys
from pathlib import Path
from dotenv import load_dotenv

# Add the backend directory to Python path
backend_dir = Path(__file__).parent
sys.path.insert(0, str(backend_dir))

# Load environment variables
env_path = backend_dir / '.env'
if not env_path.exists():
    env_path = backend_dir.parent / '.env'
load_dotenv(dotenv_path=env_path)

# Import the new application structure
from app.main import (
    app,
    get_db_connection,
    require_auth,
    sessions,
    user_csrf_tokens,
    DB_CONFIG,
    JWT_SECRET_KEY,
    JWT_ALGORITHM,
    JWT_EXPIRATION_HOURS,
    week_number,
    rand_number,
    create_access_token,
    verify_token,
    get_current_user,
    get_session
)

# Import routes for backward compatibility
# TODO: These will be migrated to the new structure in subsequent phases
try:
    from routes import router
    app.include_router(router)
except ImportError:
    print("Warning: Legacy routes.py not found. Using new structure only.")

# For development server
if __name__ == "__main__":
    import uvicorn
    uvicorn.run(
        "main:app",
        host="0.0.0.0",
        port=8000,
        reload=True,
        log_level="info"
    )