# Backend Production Deployment Package

## 📦 Production Files Included

### Core Application Files
- `app/` - Complete FastAPI application
  - `api/v1/` - All API endpoints (auth, users, batches, products, emails, activity_logs, login_logs, sap_integration)
  - `core/` - Configuration, dependencies, error handlers, exceptions
  - `models/` - Pydantic schemas and SAP schemas
  - `repositories/` - Data access layer
  - `services/` - Business logic layer
  - `utils/` - Database utilities
  - `static/` - Static files and custom Swagger UI
- `main.py` - Legacy entry point
- `passenger_wsgi.py` - WSGI entry point for production servers
- `routes.py` - Legacy routes (if needed)

### Configuration Files
- `.env.example` - Environment template
- `.env.production.example` - Production environment template
- `requirements.txt` - Python dependencies
- `requirements-server.txt` - Server-specific dependencies

### Documentation
- `README.md` - Complete setup and usage guide
- `API_DOCUMENTATION.md` - Full API reference
- `SAP_INTEGRATION_GUIDE.md` - SAP integration documentation
- `EXTERNAL_API_DOCUMENTATION.md` - External system integration
- `ENV_PRODUCTION_CHECKLIST.md` - Production deployment checklist

### Utilities & Scripts
- `scripts/generate_api_key.py` - API key generation
- `scripts/test_external_api.py` - API testing
- `email_service.py` - Email service integration
- `sap_simulator.py` - SAP simulator for testing
- `sap_simulator_repository.py` - SAP data access

### Database Migrations
- `migrations/` - All database migration scripts

### Static Assets
- `static/` - Swagger UI customizations and logos
- `images/` - Logo files

## 🚫 Files Excluded from Production
- `venv/` - Virtual environment (recreate on server)
- `__pycache__/` - Python cache files
- `.pytest_cache/` - Test cache
- `tests/` - Test files (optional for production)
- `.env` - Development environment (create new for production)
- Development scripts and tools

## 🔧 Production Setup Steps

1. **Upload and Extract**
   ```bash
   unzip backend_production.zip
   cd backend
   ```

2. **Create Virtual Environment**
   ```bash
   python -m venv venv
   source venv/bin/activate  # Linux/Mac
   # or
   venv\Scripts\activate     # Windows
   ```

3. **Install Dependencies**
   ```bash
   pip install -r requirements.txt
   ```

4. **Configure Environment**
   ```bash
   cp .env.production.example .env
   # Edit .env with production values
   ```

5. **Database Setup**
   - Create production database
   - Run migrations if needed
   - Update DB_* variables in .env

6. **Security Configuration**
   - Generate secure JWT_SECRET_KEY (32+ characters)
   - Generate secure SAP_API_KEY (64+ characters)
   - Set DEBUG=false
   - Configure CORS_ORIGINS for production domains

7. **Start Production Server**
   ```bash
   # Option 1: Gunicorn (recommended)
   pip install gunicorn
   gunicorn app.main:app -w 4 -k uvicorn.workers.UvicornWorker --bind 0.0.0.0:8001

   # Option 2: Direct uvicorn
   uvicorn app.main:app --host 0.0.0.0 --port 8001 --workers 4

   # Option 3: WSGI server (Apache/Nginx)
   # Use passenger_wsgi.py as entry point
   ```

## 🔐 Production Security Checklist

- [ ] Set DEBUG=false
- [ ] Generate secure JWT_SECRET_KEY
- [ ] Generate secure SAP_API_KEY
- [ ] Configure production database credentials
- [ ] Set proper CORS_ORIGINS
- [ ] Configure SMTP settings
- [ ] Set up HTTPS/SSL certificates
- [ ] Configure firewall rules
- [ ] Set up monitoring and logging

## 📊 Health Check Endpoints

- `GET /health` - Application health status
- `GET /` - Basic API information
- `GET /docs` - API documentation (disable in production if needed)

## 🌐 Production URLs

Update these in your .env file:
- BASE_URL=https://your-domain.com
- FRONTEND_URL=https://your-frontend-domain.com
- SAP_BTP_BASE_URL=https://your-btp-endpoint.com

## 📞 Support

For deployment issues:
- Check logs for errors
- Verify database connectivity
- Test API endpoints
- Review environment configuration